from byu_pytest_utils import run_python_script, this_folder, max_score, test_files,dialog
import filecmp
import pytest


@pytest.fixture(scope="module",autouse=True)
def run_program():
    script = this_folder / "admissions.py"
    run_python_script(script)


@max_score(15)
@dialog(test_files / "key_student_scores.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'student_scores.csv',
        output_file=this_folder / "student_scores.csv"
)
def test_student_scores():
    ...


@max_score(5)
@dialog(test_files / "key_chosen_students.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'chosen_students.csv',
        output_file=this_folder / "chosen_students.csv"
)
def test_chosen_student():
    ...


@max_score(5)
@dialog(test_files / "key_outliers.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'outliers.csv',
        output_file=this_folder / "outliers.csv"
)
def test_outliers():
    ...


@max_score(5)
@dialog(test_files / "key_chosen_improved.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'chosen_improved.csv',
        output_file=this_folder / "chosen_improved.csv"
)
def test_chosen_improved():
    ...


@max_score(5)
@dialog(test_files / "key_better_improved.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'better_improved.csv',
        output_file=this_folder / "better_improved.csv")
def test_better_improved():
    ...

@max_score(5)
@dialog(test_files / "key_outliers.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'outliers.csv',
        output_file=this_folder / "outliers.csv"
)
def test_outliers():
    ...


@max_score(15)
@dialog(test_files / "key_composite_chosen.csv",
        "admissions.py", test_files / 'admission_algorithms_dataset.csv', this_folder / 'composite_chosen.csv',
        output_file=this_folder / "composite_chosen.csv"
)
def test_outliers():
    ...

